@extends('install')
@section('content')
    <div class="container pt-5">
        <div class="row">
            <div class="col-xl-6 mx-auto">
                <div class="card">
                    <div class="card-body flex flex-col justify-center items-center">
                        <div class="mar-ver pad-btm text-center">
                            <div class="flex justify-center"><svg class="h-20" xmlns="http://www.w3.org/2000/svg" zoomAndPan="magnify" viewBox="0 0 277.5 89.999999" preserveAspectRatio="xMidYMid meet" version="1.0"><defs><g/><clipPath id="f23d95e3a1"><path d="M 2.570312 7.480469 L 61.066406 7.480469 L 61.066406 66.234375 L 2.570312 66.234375 Z M 2.570312 7.480469 " clip-rule="nonzero"/></clipPath><clipPath id="3be2d087ce"><path d="M 25.105469 61.855469 L 58.855469 61.855469 L 58.855469 82.464844 L 25.105469 82.464844 Z M 25.105469 61.855469 " clip-rule="nonzero"/></clipPath></defs><g clip-path="url(#f23d95e3a1)"><path fill="#7366ff" d="M 21.839844 60.703125 C 14.308594 56.433594 9.222656 48.328125 9.222656 39.03125 C 9.222656 25.289062 20.324219 14.152344 34.019531 14.152344 C 41.589844 14.152344 48.367188 17.554688 52.914062 22.917969 L 61.066406 22.917969 C 55.582031 13.675781 45.523438 7.480469 34.019531 7.480469 C 16.652344 7.480469 2.570312 21.605469 2.570312 39.03125 C 2.570312 50.582031 8.757812 60.679688 17.992188 66.179688 L 21.839844 60.703125 " fill-opacity="1" fill-rule="nonzero"/></g><g clip-path="url(#3be2d087ce)"><path fill="#7366ff" d="M 41.371094 62.792969 C 41.09375 62.878906 40.816406 62.960938 40.539062 63.039062 L 25.140625 69.304688 C 26.191406 69.613281 27.261719 69.871094 28.355469 70.070312 L 58.820312 82.464844 L 44.386719 61.917969 C 43.402344 62.277344 42.394531 62.570312 41.371094 62.792969 " fill-opacity="1" fill-rule="nonzero"/></g><path fill="#4c5270" d="M 36.359375 56.050781 C 45.328125 56.050781 52.601562 48.753906 52.601562 39.757812 C 52.601562 30.757812 45.328125 23.460938 36.359375 23.460938 C 31.402344 23.460938 26.964844 25.691406 23.984375 29.203125 L 18.644531 29.203125 C 22.234375 23.148438 28.824219 19.089844 36.359375 19.089844 C 47.734375 19.089844 56.957031 28.34375 56.957031 39.757812 C 56.957031 49.898438 49.675781 58.335938 40.070312 60.085938 L 20.117188 68.207031 L 29.667969 54.609375 C 31.707031 55.535156 33.972656 56.050781 36.359375 56.050781 " fill-opacity="1" fill-rule="nonzero"/><path fill="#7366ff" d="M 30.1875 39.03125 C 30.1875 40.507812 28.992188 41.707031 27.519531 41.707031 C 26.046875 41.707031 24.851562 40.507812 24.851562 39.03125 C 24.851562 37.550781 26.046875 36.351562 27.519531 36.351562 C 28.992188 36.351562 30.1875 37.550781 30.1875 39.03125 " fill-opacity="1" fill-rule="nonzero"/><path fill="#7366ff" d="M 38.226562 39.03125 C 38.226562 40.507812 37.03125 41.707031 35.558594 41.707031 C 34.082031 41.707031 32.890625 40.507812 32.890625 39.03125 C 32.890625 37.550781 34.082031 36.351562 35.558594 36.351562 C 37.03125 36.351562 38.226562 37.550781 38.226562 39.03125 " fill-opacity="1" fill-rule="nonzero"/><path fill="#7366ff" d="M 46.265625 39.03125 C 46.265625 40.507812 45.070312 41.707031 43.597656 41.707031 C 42.121094 41.707031 40.929688 40.507812 40.929688 39.03125 C 40.929688 37.550781 42.121094 36.351562 43.597656 36.351562 C 45.070312 36.351562 46.265625 37.550781 46.265625 39.03125 " fill-opacity="1" fill-rule="nonzero"/><g fill="#7366ff" fill-opacity="1"><g transform="translate(72.13776, 43.183045)"><g><path d="M 15.796875 0 L 15.796875 -9.625 L 10.921875 -9.625 L 10.921875 0 L 1.953125 0 L 1.953125 -26.375 L 10.921875 -26.375 L 10.921875 -16.796875 L 15.796875 -16.796875 L 15.796875 -26.375 L 24.765625 -26.375 L 24.765625 0 Z M 15.796875 0 "/></g></g></g><g fill="#7366ff" fill-opacity="1"><g transform="translate(100.161762, 43.183045)"><g><path d="M 1.953125 0 L 1.953125 -26.375 L 21.28125 -26.375 L 21.28125 -19.984375 L 10.890625 -19.984375 L 10.890625 -16.453125 L 19.484375 -16.453125 L 19.484375 -10.203125 L 10.890625 -10.203125 L 10.890625 -6.40625 L 21.28125 -6.40625 L 21.28125 0 Z M 1.953125 0 "/></g></g></g><g fill="#7366ff" fill-opacity="1"><g transform="translate(124.582178, 43.183045)"><g><path d="M 1.953125 0 L 1.953125 -26.375 L 10.921875 -26.375 L 10.921875 -6.75 L 19.75 -6.75 L 19.75 0 Z M 1.953125 0 "/></g></g></g><g fill="#7366ff" fill-opacity="1"><g transform="translate(146.319068, 43.183045)"><g><path d="M 1.953125 -26.375 L 15.484375 -26.375 C 17.765625 -26.375 19.484375 -26.046875 20.640625 -25.390625 C 21.804688 -24.742188 22.585938 -23.78125 22.984375 -22.5 C 23.378906 -21.226562 23.578125 -19.453125 23.578125 -17.171875 C 23.578125 -15.054688 23.390625 -13.359375 23.015625 -12.078125 C 22.648438 -10.796875 21.882812 -9.796875 20.71875 -9.078125 C 19.5625 -8.367188 17.816406 -8.015625 15.484375 -8.015625 L 10.921875 -8.015625 L 10.921875 0 L 1.953125 0 Z M 12.109375 -14.265625 C 12.910156 -14.265625 13.46875 -14.320312 13.78125 -14.4375 C 14.101562 -14.550781 14.316406 -14.789062 14.421875 -15.15625 C 14.523438 -15.53125 14.578125 -16.203125 14.578125 -17.171875 C 14.578125 -18.148438 14.523438 -18.835938 14.421875 -19.234375 C 14.316406 -19.628906 14.109375 -19.875 13.796875 -19.96875 C 13.492188 -20.070312 12.929688 -20.125 12.109375 -20.125 L 10.921875 -20.125 L 10.921875 -14.265625 Z M 12.109375 -14.265625 "/></g></g></g><g fill="#4c5270" fill-opacity="1"><g transform="translate(171.994298, 43.183045)"><g><path d="M 1.953125 -26.375 L 11.734375 -26.375 C 15.796875 -26.375 18.671875 -26.007812 20.359375 -25.28125 C 22.046875 -24.550781 23.085938 -23.363281 23.484375 -21.71875 C 23.878906 -20.070312 24.078125 -17.226562 24.078125 -13.1875 C 24.078125 -9.144531 23.878906 -6.300781 23.484375 -4.65625 C 23.085938 -3.007812 22.046875 -1.820312 20.359375 -1.09375 C 18.671875 -0.363281 15.796875 0 11.734375 0 L 1.953125 0 Z M 11.84375 -6.40625 C 13 -6.40625 13.773438 -6.519531 14.171875 -6.75 C 14.566406 -6.976562 14.8125 -7.492188 14.90625 -8.296875 C 15.007812 -9.109375 15.0625 -10.726562 15.0625 -13.15625 C 15.0625 -15.632812 15.007812 -17.273438 14.90625 -18.078125 C 14.8125 -18.878906 14.570312 -19.394531 14.1875 -19.625 C 13.800781 -19.863281 13.019531 -19.984375 11.84375 -19.984375 L 10.921875 -19.984375 L 10.921875 -6.40625 Z M 11.84375 -6.40625 "/></g></g></g><g fill="#4c5270" fill-opacity="1"><g transform="translate(198.983225, 43.183045)"><g><path d="M 1.953125 0 L 1.953125 -26.375 L 21.28125 -26.375 L 21.28125 -19.984375 L 10.890625 -19.984375 L 10.890625 -16.453125 L 19.484375 -16.453125 L 19.484375 -10.203125 L 10.890625 -10.203125 L 10.890625 -6.40625 L 21.28125 -6.40625 L 21.28125 0 Z M 1.953125 0 "/></g></g></g><g fill="#4c5270" fill-opacity="1"><g transform="translate(223.403641, 43.183045)"><g><path d="M 12.265625 0.3125 C 10.628906 0.3125 8.847656 0.242188 6.921875 0.109375 C 4.992188 -0.015625 3.363281 -0.179688 2.03125 -0.390625 L 2.03125 -6.484375 C 5.144531 -6.222656 7.613281 -6.09375 9.4375 -6.09375 C 10.53125 -6.09375 11.3125 -6.113281 11.78125 -6.15625 C 12.257812 -6.195312 12.585938 -6.28125 12.765625 -6.40625 C 12.941406 -6.53125 13.050781 -6.6875 13.09375 -6.875 C 13.132812 -7.070312 13.15625 -7.390625 13.15625 -7.828125 C 13.15625 -8.335938 13.078125 -8.695312 12.921875 -8.90625 C 12.765625 -9.125 12.484375 -9.28125 12.078125 -9.375 C 11.671875 -9.46875 10.878906 -9.585938 9.703125 -9.734375 L 5.21875 -10.3125 C 3.726562 -10.488281 2.695312 -11.257812 2.125 -12.625 C 1.550781 -14 1.265625 -15.988281 1.265625 -18.59375 C 1.265625 -20.789062 1.710938 -22.484375 2.609375 -23.671875 C 3.503906 -24.859375 4.695312 -25.65625 6.1875 -26.0625 C 7.6875 -26.476562 9.519531 -26.6875 11.6875 -26.6875 C 13.300781 -26.6875 14.957031 -26.609375 16.65625 -26.453125 C 18.351562 -26.304688 19.71875 -26.113281 20.75 -25.875 L 20.75 -19.859375 C 19.75 -19.984375 18.53125 -20.082031 17.09375 -20.15625 C 15.664062 -20.238281 14.351562 -20.28125 13.15625 -20.28125 C 11.875 -20.28125 11.082031 -20.191406 10.78125 -20.015625 C 10.394531 -19.753906 10.203125 -19.359375 10.203125 -18.828125 C 10.203125 -18.335938 10.242188 -17.988281 10.328125 -17.78125 C 10.421875 -17.582031 10.597656 -17.4375 10.859375 -17.34375 C 11.128906 -17.257812 11.625 -17.164062 12.34375 -17.0625 L 16.375 -16.5625 C 17.550781 -16.40625 18.523438 -16.132812 19.296875 -15.75 C 20.078125 -15.375 20.726562 -14.6875 21.25 -13.6875 C 21.8125 -12.632812 22.09375 -10.921875 22.09375 -8.546875 C 22.09375 -5.992188 21.679688 -4.078125 20.859375 -2.796875 C 20.035156 -1.515625 18.929688 -0.675781 17.546875 -0.28125 C 16.171875 0.113281 14.410156 0.3125 12.265625 0.3125 Z M 12.265625 0.3125 "/></g></g></g><g fill="#4c5270" fill-opacity="1"><g transform="translate(248.054071, 43.183045)"><g><path d="M 16.90625 0 L 11.3125 -10.28125 L 10.921875 -10.28125 L 10.921875 0 L 1.953125 0 L 1.953125 -26.375 L 10.921875 -26.375 L 10.921875 -16.53125 L 11.3125 -16.53125 L 17.03125 -26.375 L 26.578125 -26.375 L 18.640625 -14 L 26.6875 0 Z M 16.90625 0 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(122.941988, 64.366126)"><g><path d="M 3.984375 0.078125 C 3.316406 0.078125 2.710938 -0.0664062 2.171875 -0.359375 C 1.640625 -0.660156 1.21875 -1.066406 0.90625 -1.578125 C 0.601562 -2.097656 0.453125 -2.675781 0.453125 -3.3125 C 0.453125 -3.945312 0.601562 -4.523438 0.90625 -5.046875 C 1.21875 -5.566406 1.640625 -5.972656 2.171875 -6.265625 C 2.710938 -6.554688 3.316406 -6.703125 3.984375 -6.703125 C 4.648438 -6.703125 5.25 -6.554688 5.78125 -6.265625 C 6.320312 -5.972656 6.742188 -5.566406 7.046875 -5.046875 C 7.347656 -4.535156 7.5 -3.957031 7.5 -3.3125 C 7.5 -2.664062 7.347656 -2.085938 7.046875 -1.578125 C 6.742188 -1.066406 6.320312 -0.660156 5.78125 -0.359375 C 5.25 -0.0664062 4.648438 0.078125 3.984375 0.078125 Z M 3.984375 -0.765625 C 4.472656 -0.765625 4.910156 -0.875 5.296875 -1.09375 C 5.679688 -1.320312 5.984375 -1.628906 6.203125 -2.015625 C 6.429688 -2.398438 6.546875 -2.832031 6.546875 -3.3125 C 6.546875 -3.789062 6.429688 -4.222656 6.203125 -4.609375 C 5.984375 -5.003906 5.679688 -5.3125 5.296875 -5.53125 C 4.910156 -5.75 4.472656 -5.859375 3.984375 -5.859375 C 3.492188 -5.859375 3.050781 -5.75 2.65625 -5.53125 C 2.269531 -5.3125 1.960938 -5.003906 1.734375 -4.609375 C 1.515625 -4.222656 1.40625 -3.789062 1.40625 -3.3125 C 1.40625 -2.832031 1.515625 -2.398438 1.734375 -2.015625 C 1.960938 -1.628906 2.269531 -1.320312 2.65625 -1.09375 C 3.050781 -0.875 3.492188 -0.765625 3.984375 -0.765625 Z M 3.984375 -0.765625 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(132.138266, 64.366126)"><g><path d="M 6.6875 -6.625 L 6.6875 0 L 5.921875 0 L 1.9375 -4.9375 L 1.9375 0 L 1 0 L 1 -6.625 L 1.765625 -6.625 L 5.75 -1.6875 L 5.75 -6.625 Z M 6.6875 -6.625 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(141.069349, 64.366126)"><g><path d="M 1 -6.625 L 1.9375 -6.625 L 1.9375 -0.828125 L 5.53125 -0.828125 L 5.53125 0 L 1 0 Z M 1 -6.625 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(147.935772, 64.366126)"><g><path d="M 1 -6.625 L 1.9375 -6.625 L 1.9375 0 L 1 0 Z M 1 -6.625 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(152.112452, 64.366126)"><g><path d="M 6.6875 -6.625 L 6.6875 0 L 5.921875 0 L 1.9375 -4.9375 L 1.9375 0 L 1 0 L 1 -6.625 L 1.765625 -6.625 L 5.75 -1.6875 L 5.75 -6.625 Z M 6.6875 -6.625 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(161.043533, 64.366126)"><g><path d="M 5.796875 -0.828125 L 5.796875 0 L 1 0 L 1 -6.625 L 5.671875 -6.625 L 5.671875 -5.796875 L 1.9375 -5.796875 L 1.9375 -3.765625 L 5.265625 -3.765625 L 5.265625 -2.96875 L 1.9375 -2.96875 L 1.9375 -0.828125 Z M 5.796875 -0.828125 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(168.629743, 64.366126)"><g/></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(172.418112, 64.366126)"><g><path d="M 2.3125 -5.796875 L 0.03125 -5.796875 L 0.03125 -6.625 L 5.515625 -6.625 L 5.515625 -5.796875 L 3.25 -5.796875 L 3.25 0 L 2.3125 0 Z M 2.3125 -5.796875 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(179.218238, 64.366126)"><g><path d="M 1 -6.625 L 1.9375 -6.625 L 1.9375 0 L 1 0 Z M 1 -6.625 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(183.394916, 64.366126)"><g><path d="M 3.953125 0.078125 C 3.296875 0.078125 2.695312 -0.0664062 2.15625 -0.359375 C 1.625 -0.660156 1.207031 -1.066406 0.90625 -1.578125 C 0.601562 -2.085938 0.453125 -2.664062 0.453125 -3.3125 C 0.453125 -3.957031 0.601562 -4.535156 0.90625 -5.046875 C 1.207031 -5.566406 1.625 -5.972656 2.15625 -6.265625 C 2.695312 -6.554688 3.300781 -6.703125 3.96875 -6.703125 C 4.488281 -6.703125 4.960938 -6.613281 5.390625 -6.4375 C 5.816406 -6.269531 6.179688 -6.015625 6.484375 -5.671875 L 5.875 -5.078125 C 5.375 -5.597656 4.75 -5.859375 4 -5.859375 C 3.507812 -5.859375 3.066406 -5.75 2.671875 -5.53125 C 2.273438 -5.3125 1.960938 -5.003906 1.734375 -4.609375 C 1.515625 -4.222656 1.40625 -3.789062 1.40625 -3.3125 C 1.40625 -2.832031 1.515625 -2.398438 1.734375 -2.015625 C 1.960938 -1.628906 2.273438 -1.320312 2.671875 -1.09375 C 3.066406 -0.875 3.507812 -0.765625 4 -0.765625 C 4.738281 -0.765625 5.363281 -1.03125 5.875 -1.5625 L 6.484375 -0.96875 C 6.179688 -0.625 5.8125 -0.363281 5.375 -0.1875 C 4.945312 -0.0078125 4.472656 0.078125 3.953125 0.078125 Z M 3.953125 0.078125 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(191.483083, 64.366126)"><g><path d="M 3.15625 -2.9375 L 1.9375 -1.71875 L 1.9375 0 L 1 0 L 1 -6.625 L 1.9375 -6.625 L 1.9375 -2.921875 L 5.546875 -6.625 L 6.625 -6.625 L 3.78125 -3.640625 L 6.796875 0 L 5.6875 0 Z M 3.15625 -2.9375 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(199.533376, 64.366126)"><g><path d="M 5.796875 -0.828125 L 5.796875 0 L 1 0 L 1 -6.625 L 5.671875 -6.625 L 5.671875 -5.796875 L 1.9375 -5.796875 L 1.9375 -3.765625 L 5.265625 -3.765625 L 5.265625 -2.96875 L 1.9375 -2.96875 L 1.9375 -0.828125 Z M 5.796875 -0.828125 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(207.119585, 64.366126)"><g><path d="M 2.3125 -5.796875 L 0.03125 -5.796875 L 0.03125 -6.625 L 5.515625 -6.625 L 5.515625 -5.796875 L 3.25 -5.796875 L 3.25 0 L 2.3125 0 Z M 2.3125 -5.796875 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(213.919711, 64.366126)"><g/></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(217.70808, 64.366126)"><g><path d="M 2.921875 0.078125 C 2.421875 0.078125 1.9375 0 1.46875 -0.15625 C 1.007812 -0.3125 0.648438 -0.507812 0.390625 -0.75 L 0.734375 -1.5 C 0.992188 -1.269531 1.316406 -1.082031 1.703125 -0.9375 C 2.097656 -0.800781 2.503906 -0.734375 2.921875 -0.734375 C 3.472656 -0.734375 3.882812 -0.820312 4.15625 -1 C 4.425781 -1.1875 4.5625 -1.4375 4.5625 -1.75 C 4.5625 -1.976562 4.488281 -2.160156 4.34375 -2.296875 C 4.195312 -2.441406 4.015625 -2.550781 3.796875 -2.625 C 3.578125 -2.707031 3.269531 -2.796875 2.875 -2.890625 C 2.375 -3.003906 1.96875 -3.117188 1.65625 -3.234375 C 1.351562 -3.359375 1.09375 -3.546875 0.875 -3.796875 C 0.65625 -4.046875 0.546875 -4.382812 0.546875 -4.8125 C 0.546875 -5.164062 0.640625 -5.484375 0.828125 -5.765625 C 1.015625 -6.046875 1.296875 -6.269531 1.671875 -6.4375 C 2.054688 -6.613281 2.53125 -6.703125 3.09375 -6.703125 C 3.476562 -6.703125 3.859375 -6.648438 4.234375 -6.546875 C 4.617188 -6.453125 4.945312 -6.304688 5.21875 -6.109375 L 4.90625 -5.359375 C 4.625 -5.535156 4.328125 -5.671875 4.015625 -5.765625 C 3.703125 -5.859375 3.394531 -5.90625 3.09375 -5.90625 C 2.550781 -5.90625 2.144531 -5.804688 1.875 -5.609375 C 1.613281 -5.410156 1.484375 -5.15625 1.484375 -4.84375 C 1.484375 -4.613281 1.554688 -4.425781 1.703125 -4.28125 C 1.859375 -4.144531 2.046875 -4.035156 2.265625 -3.953125 C 2.492188 -3.878906 2.800781 -3.800781 3.1875 -3.71875 C 3.675781 -3.59375 4.070312 -3.46875 4.375 -3.34375 C 4.6875 -3.226562 4.945312 -3.046875 5.15625 -2.796875 C 5.375 -2.554688 5.484375 -2.226562 5.484375 -1.8125 C 5.484375 -1.457031 5.390625 -1.132812 5.203125 -0.84375 C 5.015625 -0.5625 4.726562 -0.335938 4.34375 -0.171875 C 3.957031 -0.00390625 3.484375 0.078125 2.921875 0.078125 Z M 2.921875 0.078125 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(224.830219, 64.366126)"><g><path d="M 3.734375 0.078125 C 2.859375 0.078125 2.171875 -0.171875 1.671875 -0.671875 C 1.179688 -1.179688 0.9375 -1.910156 0.9375 -2.859375 L 0.9375 -6.625 L 1.890625 -6.625 L 1.890625 -2.890625 C 1.890625 -1.472656 2.507812 -0.765625 3.75 -0.765625 C 4.351562 -0.765625 4.816406 -0.9375 5.140625 -1.28125 C 5.460938 -1.632812 5.625 -2.171875 5.625 -2.890625 L 5.625 -6.625 L 6.546875 -6.625 L 6.546875 -2.859375 C 6.546875 -1.910156 6.296875 -1.179688 5.796875 -0.671875 C 5.304688 -0.171875 4.617188 0.078125 3.734375 0.078125 Z M 3.734375 0.078125 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(233.562419, 64.366126)"><g><path d="M 3.578125 -6.625 C 4.429688 -6.625 5.101562 -6.414062 5.59375 -6 C 6.09375 -5.59375 6.34375 -5.03125 6.34375 -4.3125 C 6.34375 -3.59375 6.09375 -3.023438 5.59375 -2.609375 C 5.101562 -2.203125 4.429688 -2 3.578125 -2 L 1.9375 -2 L 1.9375 0 L 1 0 L 1 -6.625 Z M 3.546875 -2.828125 C 4.148438 -2.828125 4.609375 -2.953125 4.921875 -3.203125 C 5.234375 -3.460938 5.390625 -3.832031 5.390625 -4.3125 C 5.390625 -4.789062 5.234375 -5.15625 4.921875 -5.40625 C 4.609375 -5.664062 4.148438 -5.796875 3.546875 -5.796875 L 1.9375 -5.796875 L 1.9375 -2.828125 Z M 3.546875 -2.828125 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(241.641127, 64.366126)"><g><path d="M 3.578125 -6.625 C 4.429688 -6.625 5.101562 -6.414062 5.59375 -6 C 6.09375 -5.59375 6.34375 -5.03125 6.34375 -4.3125 C 6.34375 -3.59375 6.09375 -3.023438 5.59375 -2.609375 C 5.101562 -2.203125 4.429688 -2 3.578125 -2 L 1.9375 -2 L 1.9375 0 L 1 0 L 1 -6.625 Z M 3.546875 -2.828125 C 4.148438 -2.828125 4.609375 -2.953125 4.921875 -3.203125 C 5.234375 -3.460938 5.390625 -3.832031 5.390625 -4.3125 C 5.390625 -4.789062 5.234375 -5.15625 4.921875 -5.40625 C 4.609375 -5.664062 4.148438 -5.796875 3.546875 -5.796875 L 1.9375 -5.796875 L 1.9375 -2.828125 Z M 3.546875 -2.828125 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(249.719835, 64.366126)"><g><path d="M 3.984375 0.078125 C 3.316406 0.078125 2.710938 -0.0664062 2.171875 -0.359375 C 1.640625 -0.660156 1.21875 -1.066406 0.90625 -1.578125 C 0.601562 -2.097656 0.453125 -2.675781 0.453125 -3.3125 C 0.453125 -3.945312 0.601562 -4.523438 0.90625 -5.046875 C 1.21875 -5.566406 1.640625 -5.972656 2.171875 -6.265625 C 2.710938 -6.554688 3.316406 -6.703125 3.984375 -6.703125 C 4.648438 -6.703125 5.25 -6.554688 5.78125 -6.265625 C 6.320312 -5.972656 6.742188 -5.566406 7.046875 -5.046875 C 7.347656 -4.535156 7.5 -3.957031 7.5 -3.3125 C 7.5 -2.664062 7.347656 -2.085938 7.046875 -1.578125 C 6.742188 -1.066406 6.320312 -0.660156 5.78125 -0.359375 C 5.25 -0.0664062 4.648438 0.078125 3.984375 0.078125 Z M 3.984375 -0.765625 C 4.472656 -0.765625 4.910156 -0.875 5.296875 -1.09375 C 5.679688 -1.320312 5.984375 -1.628906 6.203125 -2.015625 C 6.429688 -2.398438 6.546875 -2.832031 6.546875 -3.3125 C 6.546875 -3.789062 6.429688 -4.222656 6.203125 -4.609375 C 5.984375 -5.003906 5.679688 -5.3125 5.296875 -5.53125 C 4.910156 -5.75 4.472656 -5.859375 3.984375 -5.859375 C 3.492188 -5.859375 3.050781 -5.75 2.65625 -5.53125 C 2.269531 -5.3125 1.960938 -5.003906 1.734375 -4.609375 C 1.515625 -4.222656 1.40625 -3.789062 1.40625 -3.3125 C 1.40625 -2.832031 1.515625 -2.398438 1.734375 -2.015625 C 1.960938 -1.628906 2.269531 -1.320312 2.65625 -1.09375 C 3.050781 -0.875 3.492188 -0.765625 3.984375 -0.765625 Z M 3.984375 -0.765625 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(258.916117, 64.366126)"><g><path d="M 5.421875 0 L 4 -2.03125 C 3.820312 -2.019531 3.679688 -2.015625 3.578125 -2.015625 L 1.9375 -2.015625 L 1.9375 0 L 1 0 L 1 -6.625 L 3.578125 -6.625 C 4.429688 -6.625 5.101562 -6.414062 5.59375 -6 C 6.09375 -5.59375 6.34375 -5.03125 6.34375 -4.3125 C 6.34375 -3.800781 6.21875 -3.363281 5.96875 -3 C 5.71875 -2.644531 5.359375 -2.382812 4.890625 -2.21875 L 6.453125 0 Z M 3.546875 -2.828125 C 4.148438 -2.828125 4.609375 -2.953125 4.921875 -3.203125 C 5.234375 -3.460938 5.390625 -3.832031 5.390625 -4.3125 C 5.390625 -4.789062 5.234375 -5.15625 4.921875 -5.40625 C 4.609375 -5.664062 4.148438 -5.796875 3.546875 -5.796875 L 1.9375 -5.796875 L 1.9375 -2.828125 Z M 3.546875 -2.828125 "/></g></g></g><g fill="#7b7b7b" fill-opacity="1"><g transform="translate(267.042178, 64.366126)"><g><path d="M 2.3125 -5.796875 L 0.03125 -5.796875 L 0.03125 -6.625 L 5.515625 -6.625 L 5.515625 -5.796875 L 3.25 -5.796875 L 3.25 0 L 2.3125 0 Z M 2.3125 -5.796875 "/></g></g></g></svg></div>
                            @if ($errors->any())
                                <div role="alert">
                                    <div class="border border-red-400 rounded-b bg-red-100 px-4 py-3 text-red-700">
                                        @foreach ($errors->all() as $error)
                                            <p>{{ $error }}</p>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                            <h1 class="h3 text-2xl font-bold mt-4">Chat and Mail Setup</h1>
                            <p class="mt-2 max-w-3xl text-center mx-auto">
                                Please register on <a href="#">pusher</a> and fill out the following fields.
                            </p>
                        </div>

                        <div class="text-muted font-13">
                            <form method="POST" action="{{ route('install.mail_setup.save') }}">
                                @csrf
                                <div class="flex justify-center">
                                    <label class="inline-flex items-center mt-3">
                                        <input id="pusherCheck" type="checkbox" name="skip_pusher" class="form-checkbox h-5 w-5 text-gray-600">
                                        <span class="ml-2 text-gray-700">Check this to skip setup <b>Pusher</b> later from dashboard settings</span>
                                    </label>
                                </div>
                                <div class="flex flex-wrap -mb-8 -mr-6 p-8" id="pusherSetup">
                                    <div class="pb-8 pr-6 w-full lg:w-1/4">
                                        <label class="form-label" for="pusherAppID">Pusher App ID:</label>
                                        <input type="text" id="pusherAppID" name="PUSHER_APP_ID" class="form-input" value="" autocomplete="off" required />
                                    </div>

                                    <div class="pb-8 pr-6 w-full lg:w-1/4">
                                        <label class="form-label" for="pusherAppKey">Pusher App Key:</label>
                                        <input type="text" id="pusherAppKey" name="PUSHER_APP_KEY" class="form-input" value="" autocomplete="off" required />
                                    </div>

                                    <div class="pb-8 pr-6 w-full lg:w-1/4">
                                        <label class="form-label" for="pusherAppSecret">Pusher App Secret:</label>
                                        <input type="text" id="pusherAppSecret" name="PUSHER_APP_SECRET" class="form-input" autocomplete="off" required />
                                    </div>

                                    <div class="pb-8 pr-6 w-full lg:w-1/4">
                                        <label class="form-label" for="pusherAppCluster">Pusher App Cluster:</label>
                                        <input type="text" id="pusherAppCluster" name="PUSHER_APP_CLUSTER" class="form-input" autocomplete="off" required />
                                    </div>
                                </div>

                                <p class="justify-center text-center"> Please fill up following fields for the SMTP mail setup. You can use any SMTP info such as your own domain mail smtp, GMail SMTP, MailGun, SendGrid, MailChimp, etc.  </p>
                                <div class="flex justify-center">
                                    <label class="inline-flex items-center mt-3">
                                        <input id="smtpCheck" type="checkbox" name="skip_mailer" class="form-checkbox h-5 w-5 text-gray-600">
                                        <span class="ml-2 text-gray-700">Check this to skip setup <b>SMTP</b> later from dashboard settings</span>
                                    </label>
                                </div>
                                <div class="flex flex-wrap -mb-8 -mr-6 p-8" id="smtpSetup">
                                    <div class="pb-8 pr-6 w-full lg:w-1/4">
                                        <label class="form-label" for="mailerHost">SMTP Host:</label>
                                        <input type="text" id="mailerHost" name="MAIL_HOST" class="form-input" value="" autocomplete="off" required />
                                    </div>

                                    <div class="pb-8 pr-6 w-full lg:w-1/4">
                                        <label class="form-label" for="mailerPort">SMTP Port:</label>
                                        <input type="text" id="mailerPort" name="MAIL_PORT" class="form-input" value="587" autocomplete="off" required />
                                    </div>

                                    <div class="pb-8 pr-6 w-full lg:w-1/4">
                                        <label class="form-label" for="smtpUsername">SMTP Username:</label>
                                        <input type="text" id="smtpUsername" name="MAIL_USERNAME" class="form-input" autocomplete="off" required />
                                    </div>

                                    <div class="pb-8 pr-6 w-full lg:w-1/4">
                                        <label class="form-label" for="smtpPassword">SMTP Password:</label>
                                        <input type="text" id="smtpPassword" name="MAIL_PASSWORD" class="form-input" autocomplete="off" required />
                                    </div>

                                    <div class="pb-8 pr-6 w-full lg:w-1/4">
                                        <label class="form-label" for="smtpEncryption">SMTP Encryption:</label>
                                        <input type="text" id="smtpEncryption" name="MAIL_ENCRYPTION" class="form-input" autocomplete="off" required />
                                    </div>

                                    <div class="pb-8 pr-6 w-full lg:w-1/4">
                                        <label class="form-label" for="MailFromAddress">Mail from address:</label>
                                        <input type="text" id="MailFromAddress" name="MAIL_FROM_ADDRESS" class="form-input" autocomplete="off" required />
                                    </div>

                                    <div class="pb-8 pr-6 w-full lg:w-1/4">
                                        <label class="form-label" for="mailFromName">Mail from name:</label>
                                        <input type="text" id="mailFromName" name="MAIL_FROM_NAME" class="form-input" autocomplete="off" required />
                                    </div>
                                </div>

                                <div class="flex justify-end pr-8">
                                    <button type="submit" class="btn btn-indigo hover:bg-indigo-800">Next Step >></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function toggleActive(sel, boolean) {
            var el = document.getElementById(sel),
                all = el.getElementsByTagName('input'),
                i;
            for (i = 0; i < all.length; i++) {
                all[i].disabled = boolean;
            }
        }
        document.getElementById('pusherCheck').onchange = function () {
            toggleActive('pusherSetup', this.checked);
        }
        document.getElementById('smtpCheck').onchange = function () {
            toggleActive('smtpSetup', this.checked);
        }

    </script>
@endsection
